CREATE TRIGGER E_LOGON
   ON ALL SERVER
   FOR LOGON
AS
BEGIN

-- Si la connexion ne seffectue pas dans Management Studio
IF APP_NAME() NOT LIKE 'Microsoft SQL Server Management Studio%'
-- et que le compte de connexion est sa
   AND (ORIGINAL_LOGIN()= 'sa'
-- ou que le compte possde le rle sysadmin
   OR EXISTS(SELECT * 
             FROM   sys.server_principals AS cnx
                    INNER JOIN sys.server_role_members AS rm
                          ON cnx.principal_id = rm.member_principal_id
                    INNER JOIN sys.server_principals AS rol
                          ON rm.role_principal_id = rol.principal_id
             WHERE  cnx.name = ORIGINAL_LOGIN()
               AND  rol.name = 'sysadmin')
-- ou que le compte possde le privilge "CONTROL SERVER"
   OR EXISTS(SELECT *
             FROM   sys.server_principals AS cnx
                    INNER JOIN sys.server_permissions AS sp
                          ON cnx.principal_id = sp.grantee_principal_id
             WHERE  cnx.name = ORIGINAL_LOGIN()
               AND  sp.permission_name = 'CONTROL SERVER'))
BEGIN
-- alors on annule
   ROLLBACK;
   RAISERROR('Une connexion sa ou de rle sysadmin, ou bien ayant le privilge "CONTROL SERVER" est interdite pour des applications courantes.', 16, 1);
END;
END